# Academic performance 🐍

### О сервисе
Сервис подсчета успеваемости студентов

### Зависимости
- `Python 3.11`
- `Poetry (pyproject.toml)`
- `Docker (Kafka, ETCD)`


## 1. Установка зависимостей (для разработки) с VPN:
1. > `poetry config http-basic.umschool {USER} {PASSWORD}`
2. > `poetry env use X.Y`, где `X.Y` - `версия Python` 
3. > `poetry install`


## 2. Запуск сервиса
#### 2.1.  Добавление необходимых данных
> Необходимо, в корне проекта, создать директорию `secrets`, с файлом `pip_extra_index_url`,
который должен содержать URL Umschool PyPI (включающий логин и пароль)
[`https://login:password@pypi.example.net/simple/`]

> Если сервер ETCD имеет аутентификацию, то необходимо:
> 1. Добавить файл сертификата `ca_cert.crt` (от LOCAL_STORAGE: ETCD) в папку `app`
> > P.S. При запуске с помощью docker-compose необходимо монтировать папку с сертификатом
> > в контейнер приложения (с помощью volumes, пример в docker-compose-файле)
> 2. Указать путь в переменную окружения `ACAD_PERF_STORAGE_PATH_TO_CA_CERT` относительно папки app

#### 2.2 Авторизация в docker-hub umschool
> `docker login docker-hub.umschool.net -u {username}`, затем ввести пароль

#### 2.3 Запуск контейнера
> `docker-compose up --build`

###### При необходимости создать образ приложения:
> `docker build --secret id=pip_extra_index_url,src=$(pwd)/secrets/pip_extra_index_url.txt`

## 3. Миграции
#### Создание миграции
1. Запустить контейнер/сервис `docker-compose up -d`
2. Создать миграцию (команда ниже) `alembic revision --autogenerate -m "slug"`

#### Применение миграции
```Bash
docker-compose run app alembic upgrade head
# "app" – наименование приложения в docker-compose
```

###### P.S. Столкнулся с проблемами?
1.  **Не применяются миграции?**
    + Запусти контейнер/сервис
    + Зайди в контейнер сервиса "app"
    + `alembic upgrade head`


## 4. Линтеры и форматтеры
Для запуска линтеров и форматтеров используется [lintrunner](https://github.com/suo/lintrunner).

Установка зависимостей для линтера: 
+ `poetry install --only lint` или `lintrunner init`

Правила: [RUFF](https://beta.ruff.rs/docs/rules/)

Инструкция:
```shell
lintrunner init # установка зависимостей (запуск команды только в активном виртуальном окружении, а то произойдет pip install --user)
lintrunner # запустить в check моде
lintrunner -m branch_name # запустить в check моде c проверкой всех измененных файлов в сравнении с branch_namе
lintrunner -a # применить автоисправления
lintrunner --all-files # запустить в check моде с проверкой всех файлов (не только git staged)
lintrunner --all-files -a # применить автоисправления на все файлы
```