"""
    Файл, содержащий настройки приложения Faust Streaming,
    такие как URL брокера сообщений, размеры окон и т. д.
"""
import os

from decouple import config


BASE_DIR: str = os.path.dirname(
    os.path.dirname(
        os.path.abspath(__file__),
    ),
)
APP_PATH: str = os.path.join(BASE_DIR, 'app')

#   Kafka config
ACAD_PERF_KAFKA_BOOTSTRAP_SERVER: str = config('ACAD_PERF_KAFKA_BOOTSTRAP_SERVER', default='kafka://localhost:9093')
ACAD_PERF_KAFKA_SERVER_PROCESSED: str = f'kafka://{ACAD_PERF_KAFKA_BOOTSTRAP_SERVER.replace("kafka://", "")}'
ACAD_PERF_KAFKA_TOPIC: str = config('ACAD_PERF_KAFKA_TOPIC', default='academic-performance')
ACAD_PERF_KAFKA_PARTITION_COUNT: int = config('ACAD_PERF_KAFKA_PARTITION_COUNT', cast=int, default=8)
ACAD_PERF_KAFKA_SASL_ENABLED: bool = config('ACAD_PERF_KAFKA_SASL_ENABLED', cast=bool, default=True)
ACAD_PERF_KAFKA_SASL_MECHANISM: str = config('ACAD_PERF_KAFKA_SASL_MECHANISM', cast=str, default='PLAIN')
ACAD_PERF_KAFKA_USERNAME: str = config('ACAD_PERF_KAFKA_USERNAME', default='umschooluser')
ACAD_PERF_KAFKA_PASSWORD: str = config('ACAD_PERF_KAFKA_PASSWORD', default='admin123')

#   ETCD|Redis db config
ACAD_PERF_STORAGE_PATH_TO_CA_CERT: str | None = config('ACAD_PERF_STORAGE_PATH_TO_CA_CERT', default=None)
ACAD_PERF_STORAGE_USER: str = config('ACAD_PERF_STORAGE_USER', default='')
ACAD_PERF_STORAGE_PASSWORD: str = config('ACAD_PERF_STORAGE_PASSWORD', default='')
ACAD_PERF_STORAGE_HOST: str = config('ACAD_PERF_STORAGE_HOST', default='127.0.0.1')
ACAD_PERF_STORAGE_PORT: int = config('ACAD_PERF_STORAGE_PORT', cast=int, default='2379')
ACAD_PERF_REDIS_DB: int = config('ACAD_PERF_REDIS_DB', cast=int, default=0)

# Service config
ACAD_PERF_SERVICE_ID: int | None = config('ACAD_PERF_SERVICE_ID', default=0)
ACAD_PERF_SEND_DATASPHERE_INTERVAL: int = config('ACAD_PERF_SEND_DATASPHERE_INTERVAL', default=60)

#   PGSQL db config
ACAD_PERF_DB_USER: str = config('ACAD_PERF_DB_USER', default='postgres')
ACAD_PERF_DB_PASS: str = config('ACAD_PERF_DB_PASS', default='postgres')
ACAD_PERF_DB_HOST: str = config('ACAD_PERF_DB_HOST', default='127.0.0.1')
ACAD_PERF_DB_PORT: int = config('ACAD_PERF_DB_PORT', cast=int, default=5435)
ACAD_PERF_DB_NAME: str = config('ACAD_PERF_DB_NAME', default='aps_db')
DATABASE_URL: str = f'postgresql+asyncpg://{ACAD_PERF_DB_USER}:{ACAD_PERF_DB_PASS}@{ACAD_PERF_DB_HOST}:' \
                    f'{ACAD_PERF_DB_PORT}/{ACAD_PERF_DB_NAME}'
DATABASE_MIGRATIONS_URL: str = DATABASE_URL + '?async_fallback=True'

#   Yandex datasphere config
ACAD_PERF_DATASPHERE_HIDDEN_STATES_LEN: int = config('ACAD_PERF_DATASPHERE_HIDDEN_STATES_LEN', default=768)
ACAD_PERF_DATASPHERE_FOLDER_ID: str = config('ACAD_PERF_DATASPHERE_FOLDER_ID', default='')
ACAD_PERF_DATASPHERE_ALIAS: str = config('ACAD_PERF_DATASPHERE_ALIAS', default='')
ACAD_PERF_DATASPHERE_CHUNK_SIZE: int = config('ACAD_PERF_DATASPHERE_CHUNK_SIZE', default=1000)

# Yandex cloud config
ACAD_PERF_YANDEX_SERVICE_ACCOUNT_ID: str = config('ACAD_PERF_YANDEX_SERVICE_ACCOUNT_ID', default='')
ACAD_PERF_YANDEX_KEY_ID: str = config('ACAD_PERF_YANDEX_KEY_ID', default='')
ACAD_PERF_YANDEX_SECRET_KEY: str = config('ACAD_PERF_YANDEX_SECRET_KEY', default='', cast=str).replace('\\n', '\n')
ACAD_PERF_YANDEX_IAM_LIVE_TIME_HOURS: int = config('ACAD_PERF_YANDEX_IAM_LIVE_TIME_HOURS', default=1)

# MONOLITH
ACAD_PERF_MONOLITH_URL: str = config('ACAD_PERF_MONOLITH_URL', default='https://umschool.net/')
ACAD_PERF_MONOLITH_API_KEY: str = config('ACAD_PERF_MONOLITH_API_KEY', default='')
ACAD_PERF_MONOLITH_API_URL: str = config('ACAD_PERF_MONOLITH_API_URL', default='private/v1/umit/update-knowledge/')

LOGGING_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            'format': '%(asctime)s %(levelname)s %(name)s %(message)s',
        },
    },
    'handlers': {
        'console': {
            'level': 'INFO',
            'class': 'logging.StreamHandler',
            'formatter': 'default',
        },
    },
    'loggers': {
        'example': {
            'handlers': ['console'],
            'level': 'INFO',
        },
    },
}
