from enum import Enum
from typing import NamedTuple, TypedDict


class TaskData(TypedDict):
    """Данные о задаче"""
    id: int  # Id выполненной задачи
    subtopic_id: int  # Id подтемы, закрепленного за задачей


class RawItem(TypedDict):
    """Элемент не обработанных данных"""
    hash_value: str  # Хеш студент-предмет
    class_type_id: int  # Id предмета
    student_id: int  # Id студента
    hw_done_ids: list[int]  # Id выполненных ДЗ
    hw_done_grade: list[float]  # Оценки за выполненные в ДЗ задачи
    task_data: list[TaskData]  # Данные о задаче
    done_tasks_cnt: int  # Кол-во выполненных задач по предмету


class RequestDataItem(NamedTuple):
    """Элемент не обработанных данных перед отправкой"""
    hw_problems_id: list[str]
    results: list[float]
    performance_problems_id: list[str]
    hidden_states: list[float]
    rv: int
    done_tasks_cnt: int


class SubtopicData(TypedDict):
    student_id: int
    subtopic_ids: list[int]


class ComputedItem(NamedTuple):
    """Элемент обработанных данных"""
    task_probability: list[float]
    new_hidden_states: list[float]
    new_rv: list[int]


class SubtopicComputedData(TypedDict):
    subtopic_id: int
    knowledge: float


class MonolithDataRequest(TypedDict):
    student_id: int
    subtopics: list[SubtopicComputedData]


class StateLivenessProbe(str, Enum):
    OK = 'OK'
    TROUBLE = 'TROUBLE'

    def __str__(self):
        return str(self.value)
