
from sqlalchemy import (
    Float,
    String,
)
from sqlalchemy.dialects.postgresql import ARRAY
from sqlalchemy.orm import Mapped, mapped_column

from config import ACAD_PERF_DATASPHERE_HIDDEN_STATES_LEN
from database import Base


class HiddenState(Base):
    hash: Mapped[str] = mapped_column(
        String(length=32),
        primary_key=True,
    )
    hidden_states: Mapped[
        list[float]
    ] = mapped_column(
        ARRAY(Float),
        nullable=True,
        default=[0.0] * ACAD_PERF_DATASPHERE_HIDDEN_STATES_LEN,
    )
    rv: Mapped[int] = mapped_column(
        default=9,
        nullable=True,
    )
    done_tasks_count: Mapped[int] = mapped_column(
        default=0,
        nullable=True,
    )
