import abc

from custom_types import ComputedItem


class BaseDataSphere(abc.ABC):
    """Интерфейс работы с датасферой"""

    @abc.abstractmethod
    def send(self, data) -> dict[str, ComputedItem]:
        """Отправка данных в датасферу"""


class DataSphere:
    """Класс работы с датасферой"""
    datasphere = None

    def __init__(self, datasphere: BaseDataSphere):
        self.datasphere = datasphere

    def recompute_data(self, data) -> dict[str, ComputedItem]:
        """Отправка данных в датасферу"""
        return self.datasphere.send(data)

